#!/usr/bin/perl -t

# OpenVPN PAM AUTHENTICATON
#   This script can be used to add PAM-based authentication
#   to OpenVPN 2.0.  The OpenVPN client must provide
#   a username/password, using the --auth-user-pass directive.
#   The OpenVPN server should specify --auth-user-pass-verify
#   with this script as the argument.  The server can
#   also optionally specify --client-cert-not-required and/or
#   --username-as-common-name.

# SCRIPT OPERATION
#   Return success or failure status based on whether or not a
#   given username/password authenticates using PAM.
#   Set the environmental variables "username" and "password"
#   prior to calling.
#
# CAVEATS
#   * Requires Authen::PAM module, which may also
#     require the pam-devel package.
#   * May need to be run as root in order to
#     access username/password file.

use Authen::PAM;
use POSIX;

# This "conversation function" will pass
# $password to PAM when it asks for it.

sub my_conv_func {
    my @res;
    while ( @_ ) {
        my $code = shift;
        my $msg = shift;
        my $ans = "";

        $ans = $password if $msg =~ /[Pp]assword/;

        push @res, (PAM_SUCCESS(),$ans);
    }
    push @res, PAM_SUCCESS();
    return @res;
}

# Identify service type to PAM
$service = "login";

# Get username/password from environment

$username = $ENV{"username"};
$password = $ENV{"password"};

# Initialize PAM object

if (!ref($pamh = new Authen::PAM($service, $username, \&my_conv_func))) {
    print "Authen::PAM init failed\n";
    exit 1;
}

# Authenticate with PAM

$res = $pamh->pam_authenticate;

# Return success or failure

if ($res == PAM_SUCCESS()) {
    exit 0;
} else {
    print "Auth '$username' failed, PAM said: ", $pamh->pam_strerror($res), "\n";
    exit 1;
}
