; OpenVPN install script for Windows, using NSIS

!include "MUI.nsh"
!include "setpath.nsi"

!define MASTER "z:\openvpn\exp\openvpn"
!define HOME "c:\src\openvpn"
!define BIN "${HOME}\bin"

!define MUI_PRODUCT "OpenVPN"
!define MUI_VERSION "1.5-beta4" # AUTO_VERSION

;--------------------------------
;Configuration

  ;General
  OutFile "openvpn-${MUI_VERSION}-install.exe"
  SetCompressor bzip2

  ShowInstDetails show
  ShowUninstDetails show

  ;Folder selection page
  InstallDir "$PROGRAMFILES\${MUI_PRODUCT}"
  
  ;Remember install folder
  InstallDirRegKey HKCU "Software\${MUI_PRODUCT}" ""

  !define SOURCE_ZIP_DEST "openvpn-${MUI_VERSION}.zip"
  !define SOURCE_ZIP_SRC "${MASTER}\${SOURCE_ZIP_DEST}"

;--------------------------------
;Modern UI Configuration

  !define MUI_NAME "${MUI_PRODUCT} ${MUI_VERSION}"

  !define MUI_WELCOMEPAGE
  !define MUI_LICENSEPAGE
  !define MUI_COMPONENTSPAGE
  !define MUI_COMPONENTSPAGE_SMALLDESC
  !define MUI_DIRECTORYPAGE
  !define MUI_FINISHPAGE
  !define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\INSTALL-win32.txt"
  !define MUI_FINISHPAGE_NOAUTOCLOSE
  !define MUI_FINISHPAGE_NOREBOOTSUPPORT
  
  !define MUI_ABORTWARNING
  
  !define MUI_UNINSTALLER
  !define MUI_UNCONFIRMPAGE
  
  !define MUI_HEADERBITMAP "${HOME}\install-win32\install-whirl.bmp"
  
;--------------------------------
;Languages
 
  !define MUI_TEXT_WELCOME_INFO_TEXT "This wizard will guide you through the installation of OpenVPN, an Open Source VPN package by James Yonan.\r\n\r\nNote that the Windows version of OpenVPN will only run on Win 2000, XP, or higher.\r\n\r\n\r\n"

  !define MUI_INNERTEXT_COMPONENTS_TOP "Select the components to install/upgrade.  To avoid conflicts, all EXE and DLL files will be installed locally, not in the Windows system32 directory."

  !insertmacro MUI_LANGUAGE "English"
  
;--------------------------------
;Language Strings

  LangString DESC_SecOpenVPNUserSpace ${LANG_ENGLISH} "Install OpenVPN user-space components, including openvpn.exe."

  LangString DESC_SecOpenSSLDLLs ${LANG_ENGLISH} "Install OpenSSL DLLs locally (may be omitted if DLLs are already installed globally)."

  LangString DESC_SecTAP ${LANG_ENGLISH} "Install/Upgrade the TAP-Win32 virtual device driver.  Will not interfere with CIPE."

  LangString DESC_SecOpenSSLUtilities ${LANG_ENGLISH} "Install the OpenSSL Utilities (used for generating public/private key pairs)."

  LangString DESC_SecOpenVPNSource ${LANG_ENGLISH} "Install (but do not unzip) the OpenVPN source distribution zip file."

  LangString DESC_SecAddPath ${LANG_ENGLISH} "Add OpenVPN executable directory to the current user's PATH."

  LangString DESC_SecAddShortcuts ${LANG_ENGLISH} "Add OpenVPN shortcuts to the current user's Start Menu."

;--------------------------------
;Data
  
  LicenseData "${HOME}\install-win32\license.txt"

;--------------------------------
;Reserve Files
  
  ;Things that need to be extracted on first (keep these lines before any File command!)
  ;Only useful for BZIP2 compression
  
  ReserveFile "${HOME}\install-win32\install-whirl.bmp"

;--------------------------------
;Installer Sections

!define SF_SELECTED 1

Section "OpenVPN User-Space Components" SecOpenVPNUserSpace

  SetOverwrite on
  SetOutPath "$INSTDIR\bin"

  File "${HOME}\openvpn.exe"

SectionEnd

Section "OpenSSL DLLs" SecOpenSSLDLLs

  SetOverwrite on
  SetOutPath "$INSTDIR\bin"
  File "${BIN}\libeay32.dll"
  File "${BIN}\libssl32.dll"

SectionEnd

Section "OpenSSL Utilities" SecOpenSSLUtilities

  SetOverwrite on
  SetOutPath "$INSTDIR\bin"
  File "${BIN}\openssl.exe"

SectionEnd

Section "TAP-Win32 Virtual Ethernet Adapter" SecTAP

  SetOverwrite on
  SetOutPath "$INSTDIR\bin"
  File "${BIN}\devcon.exe"

  FileOpen $R0 "$INSTDIR\bin\addtap.bat" w
  FileWrite $R0 "rem Add a new TAP-Win32 virtual ethernet adapter$\r$\n"
  FileWrite $R0 '"$INSTDIR\bin\devcon.exe" install "$INSTDIR\driver\OemWin2k.inf" TAP$\r$\n'
  FileWrite $R0 "pause$\r$\n"
  FileClose $R0

  FileOpen $R0 "$INSTDIR\bin\deltapall.bat" w
  FileWrite $R0 "echo WARNING: this script will delete ALL TAP-Win32 virtual adapters (use the device manager to delete adapters one at a time)$\r$\n"
  FileWrite $R0 "pause$\r$\n"
  FileWrite $R0 '"$INSTDIR\bin\devcon.exe" remove TAP$\r$\n'
  FileWrite $R0 "pause$\r$\n"
  FileClose $R0

  SetOutPath "$INSTDIR\driver"
  File "${HOME}\tap-win32\i386\OemWin2k.inf"
  File "${HOME}\tap-win32\i386\tapdrvr.sys"

SectionEnd

Section "Add OpenVPN to PATH" SecAddPath

  ; remove previously set path (if any)
  Push "$INSTDIR\bin"
  Call RemoveFromPath

  ; append our bin directory to end of current user path
  Push "$INSTDIR\bin"
  Call AddToPath

SectionEnd

Section "Add Shortcuts to Start Menu" SecAddShortcuts

  SetOverwrite on
  CreateDirectory "$SMPROGRAMS\OpenVPN"
  CreateShortCut "$SMPROGRAMS\OpenVPN\OpenVPN Win32 README.lnk" "$INSTDIR\INSTALL-win32.txt" ""
  WriteINIStr "$SMPROGRAMS\OpenVPN\OpenVPN Manual Page.url" "InternetShortcut" "URL" "http://openvpn.sourceforge.net/man.html"
  WriteINIStr "$SMPROGRAMS\OpenVPN\OpenVPN Web Site.url" "InternetShortcut" "URL" "http://openvpn.sourceforge.net/"
  CreateShortCut "$SMPROGRAMS\OpenVPN\Uninstall OpenVPN.lnk" "$INSTDIR\Uninstall.exe"

SectionEnd

Section "OpenVPN Source Code" SecOpenVPNSource

  SetOverwrite on
  SetOutPath "$INSTDIR"
  File "${SOURCE_ZIP_SRC}"

SectionEnd

;--------------------
;Post-install section

Section -post

  ;
  ; install/upgrade TAP-Win32 driver if selected, using devcon.exe
  ;
  SectionGetFlags ${SecTAP} $R0
  IntOp $R0 $R0 & ${SF_SELECTED}
  IntCmp $R0 ${SF_SELECTED} "" notap notap
    ; TAP install/update was selected.
    ; Should we install or update?
    ; If devcon error occurred, $5 will
    ; be nonzero.
    IntOp $5 0 & 0
    nsExec::ExecToStack '"$INSTDIR\bin\devcon.exe" hwids TAP'
    Pop $R0 # return value/error/timeout
    IntOp $5 $5 | $R0
    DetailPrint "devcon hwids returned: $R0"

    ; If devcon output string contains "TAP" we assume
    ; that TAP device has been previously installed,
    ; therefore we will update, not install.
    Push "TAP"
    Call StrStr
    Pop $R0

    IntCmp $5 0 0 devcon_check_error devcon_check_error
    IntCmp $R0 -1 tapinstall

 ;tapupdate:
    DetailPrint "TAP-Win32 UPDATE"
    nsExec::ExecToLog '"$INSTDIR\bin\devcon.exe" update "$INSTDIR\driver\OemWin2k.inf" TAP'
    Pop $R0 # return value/error/timeout
    IntOp $5 $5 | $R0
    DetailPrint "devcon update returned: $R0"
    Goto devcon_check_error

 tapinstall:
    DetailPrint "TAP-Win32 INSTALL"
    nsExec::ExecToLog '"$INSTDIR\bin\devcon.exe" install "$INSTDIR\driver\OemWin2k.inf" TAP'
    Pop $R0 # return value/error/timeout
    IntOp $5 $5 | $R0
    DetailPrint "devcon install returned: $R0"

 devcon_check_error:
    IntCmp $5 0 notap
    MessageBox MB_OK "An error occurred installing the TAP-Win32 device driver."

 notap:

  ; Store install folder in registry
  WriteRegStr HKCU "Software\${MUI_PRODUCT}" "" $INSTDIR

  ; Store README & license
  SetOverwrite on
  SetOutPath $INSTDIR
  File "${HOME}\install-win32\INSTALL-win32.txt"
  File "${HOME}\install-win32\license.txt"

  ; Create start menu link to source distribution zip file   
  IfFileExists "$SMPROGRAMS\OpenVPN" "" noshortcuts
    IfFileExists "$INSTDIR\${SOURCE_ZIP_DEST}" "" nosourcezip
      CreateShortCut "$SMPROGRAMS\OpenVPN\OpenVPN Source Code Distribution.lnk" "$INSTDIR\${SOURCE_ZIP_DEST}" ""

  ; Create start menu shortcuts to addtap.bat and deltapall.bat
 nosourcezip:
    IfFileExists "$INSTDIR\bin\addtap.bat" "" trydeltap
      CreateShortCut "$SMPROGRAMS\OpenVPN\Add a new TAP-Win32 virtual ethernet adapter.lnk" "$INSTDIR\bin\addtap.bat" ""

 trydeltap:
    IfFileExists "$INSTDIR\bin\deltapall.bat" "" noshortcuts
      CreateShortCut "$SMPROGRAMS\OpenVPN\Delete ALL TAP-Win32 virtual ethernet adapters.lnk" "$INSTDIR\bin\deltapall.bat" ""

 noshortcuts:
  ; Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

  ; Show up in Add/Remove programs
  WriteRegStr HKLM SOFTWARE\OpenVPN "" $INSTDIR
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\OpenVPN" "DisplayName" "OpenVPN ${MUI_VERSION}"
  WriteRegExpandStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\OpenVPN" "UninstallString" "$INSTDIR\Uninstall.exe"

SectionEnd

;Display the Finish header
;Insert this macro after the sections if you are not using a finish page
!insertmacro MUI_SECTIONS_FINISHHEADER

;--------------------------------
;Descriptions

!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecOpenVPNUserSpace} $(DESC_SecOpenVPNUserSpace)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecTAP} $(DESC_SecTAP)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecOpenSSLUtilities} $(DESC_SecOpenSSLUtilities)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecOpenSSLDLLs} $(DESC_SecOpenSSLDLLs)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecOpenVPNSource} $(DESC_SecOpenVPNSource)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAddPath} $(DESC_SecAddPath)
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAddShortcuts} $(DESC_SecAddShortcuts)
!insertmacro MUI_FUNCTIONS_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"

  DetailPrint "TAP-Win32 REMOVE"
  nsExec::ExecToLog '"$INSTDIR\bin\devcon.exe" remove TAP'
  Pop $R0 # return value/error/timeout
  DetailPrint "devcon remove returned: $R0"

  Push "$INSTDIR\bin"
  Call un.RemoveFromPath

  RMDir /r $SMPROGRAMS\OpenVPN

  Delete "$INSTDIR\bin\openvpn.exe"
  Delete "$INSTDIR\bin\libeay32.dll"
  Delete "$INSTDIR\bin\libssl32.dll"
  Delete "$INSTDIR\bin\devcon.exe"
  Delete "$INSTDIR\bin\addtap.bat"
  Delete "$INSTDIR\bin\deltapall.bat"

  Delete "$INSTDIR\driver\OemWin2k.inf"
  Delete "$INSTDIR\driver\tapdrvr.sys"

  Delete "$INSTDIR\bin\openssl.exe"

  Delete "$INSTDIR\${SOURCE_ZIP_DEST}"
  Delete "$INSTDIR\INSTALL-win32.txt"
  Delete "$INSTDIR\license.txt"
  Delete "$INSTDIR\Uninstall.exe"

  RMDir "$INSTDIR\bin"
  RMDir "$INSTDIR\driver"
  RMDir "$INSTDIR"

  DeleteRegKey /ifempty HKCU "Software\${MUI_PRODUCT}"
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\OpenVPN"
  DeleteRegKey HKLM SOFTWARE\OpenVPN

  ;Display the Finish header
  !insertmacro MUI_UNFINISHHEADER

SectionEnd
