/*
 *  OpenVPN -- An application to securely tunnel IP networks
 *             over a single UDP port, with support for SSL/TLS-based
 *             session authentication and key exchange,
 *             packet encryption, packet authentication, and
 *             packet compression.
 *
 *  Copyright (C) 2002-2003 James Yonan <jim@yonan.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program (see the file COPYING included with this
 *  distribution); if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Configuration header for Win32 using the mingw environment.
 * Manually edited based on linux version as generated by autoconf.
 *
 * config-win32.h is normally generated by copying
 * config-win32.h.in -> config-win32.h and replacing
 * [ampersand] VERSION [ampersand]
 * with the appropriate version #.  This is normally
 * done automatically by configure.ac
 */

#include <windows.h>
#include <winsock2.h>

#define sleep(x) Sleep((x)*1000)

#define SIGHUP 1
#define SIGUSR1 10

#define random rand
#define srandom srand

typedef unsigned int in_addr_t;
typedef unsigned int ssize_t;

#define FRAGMENT_ENABLE

/* Use memory debugging function in OpenSSL */
/* #undef CRYPTO_MDEBUG */

/* Use dmalloc memory debugging library */
/* #undef DMALLOC */

/* Define to 1 if you have the <arpa/inet.h> header file. */
//#define HAVE_ARPA_INET_H 1

/* Define to 1 if you have the `chdir' function. */
#define HAVE_CHDIR 1

/* Define to 1 if you have the `chroot' function. */
//#define HAVE_CHROOT 1

/* struct cmsghdr needed for extended socket error support */
//#define HAVE_CMSGHDR 1

/* Define to 1 if your compiler supports GNU GCC-style variadic macros */
#define HAVE_CPP_VARARG_MACRO_GCC 1

/* Define to 1 if your compiler supports ISO C99 variadic macros */
//#define HAVE_CPP_VARARG_MACRO_ISO 1

/* Define to 1 if you have the <ctype.h> header file. */
#define HAVE_CTYPE_H 1

/* Define to 1 if you have the `daemon' function. */
//#define HAVE_DAEMON 1

/* Define to 1 if you have the `dup' function. */
//#define HAVE_DUP 1

/* Define to 1 if you have the `dup2' function. */
//#define HAVE_DUP2 1

/* Define to 1 if you have the <errno.h> header file. */
#define HAVE_ERRNO_H 1

/* Define to 1 if you have the `EVP_CIPHER_CTX_set_key_length' function. */
#define HAVE_EVP_CIPHER_CTX_SET_KEY_LENGTH 1

/* Define to 1 if you have the <fcntl.h> header file. */
#define HAVE_FCNTL_H 1

/* Define to 1 if you have the `flock' function. */
//#define HAVE_FLOCK 1

/* Define to 1 if you have the `fork' function. */
//#define HAVE_FORK 1

/* Define to 1 if you have the `getgrnam' function. */
//#define HAVE_GETGRNAM 1

/* Define to 1 if you have the `gethostbyname' function. */
//#define HAVE_GETHOSTBYNAME 1

/* Define to 1 if you have the `getpass' function. */
//#define HAVE_GETPASS 1

/* Define to 1 if you have the `getpid' function. */
//#define HAVE_GETPID 1

/* Define to 1 if you have the `getpwnam' function. */
//#define HAVE_GETPWNAM 1

/* Define to 1 if you have the `getsockopt' function. */
#define HAVE_GETSOCKOPT 1

/* Define to 1 if you have the `gettimeofday' function. */
//#define HAVE_GETTIMEOFDAY 1

/* Define to 1 if you have the <grp.h> header file. */
//#define HAVE_GRP_H 1

/* Define to 1 if you have the `inet_aton' function. */
//#define HAVE_INET_ATON 1

/* Define to 1 if you have the `inet_ntoa' function. */
#define HAVE_INET_NTOA 1

/* Define to 1 if you have the <inttypes.h> header file. */
//#define HAVE_INTTYPES_H 1

/* struct iovec needed for IPv6 support */
//#define HAVE_IOVEC 1

/* struct iphdr needed for IPv6 support */
//#define HAVE_IPHDR 1

/* Define to 1 if you have the <linux/errqueue.h> header file. */
//#define HAVE_LINUX_ERRQUEUE_H 1

/* Define to 1 if you have the <linux/if_tun.h> header file. */
//#define HAVE_LINUX_IF_TUN_H 1

/* Define to 1 if you have the <linux/sockios.h> header file. */
//#define HAVE_LINUX_SOCKIOS_H 1

/* Define to 1 if you have the <linux/types.h> header file. */
//#define HAVE_LINUX_TYPES_H 1

/* Define to 1 if your system has a GNU libc compatible `malloc' function, and
   to 0 otherwise. */
#define HAVE_MALLOC 1

/* Define to 1 if you have the <memory.h> header file. */
//#define HAVE_MEMORY_H 1

/* Define to 1 if you have the `memset' function. */
#define HAVE_MEMSET 1

/* Define to 1 if you have the `mlockall' function. */
//#define HAVE_MLOCKALL 1

/* struct msghdr needed for extended socket error support */
//#define HAVE_MSGHDR 1

/* Define to 1 if you have the <netdb.h> header file. */
//#define HAVE_NETDB_H 1

/* Define to 1 if you have the <netinet/if_ether.h> header file. */
//#define HAVE_NETINET_IF_ETHER_H 1

/* Define to 1 if you have the <netinet/in.h> header file. */
//#define HAVE_NETINET_IN_H 1

/* Define to 1 if you have the <netinet/in_systm.h> header file. */
//#define HAVE_NETINET_IN_SYSTM_H 1

/* Define to 1 if you have the <netinet/ip.h> header file. */
//#define HAVE_NETINET_IP_H 1

/* Define to 1 if you have the <netinet/tcp.h> header file. */
//#define HAVE_NETINET_TCP_H 1

/* Define to 1 if you have the <net/if.h> header file. */
//#define HAVE_NET_IF_H 1

/* Define to 1 if you have the <net/if_tun.h> header file. */
/* #undef HAVE_NET_IF_TUN_H */

/* Define to 1 if you have the `nice' function. */
//#define HAVE_NICE 1

/* Define to 1 if you have the `openlog' function. */
//#define HAVE_OPENLOG 1

/* Define if you have POSIX threads libraries and header files. */
/* #undef HAVE_PTHREAD */

/* Define to 1 if you have the <pwd.h> header file. */
//#define HAVE_PWD_H 1

/* Define to 1 if you have the `readv' function. */
//#define HAVE_READV 1

/* Define to 1 if you have the <resolv.h> header file. */
//#define HAVE_RESOLV_H 1

/* Define to 1 if you have the `select' function. */
//#define HAVE_SELECT 1

/* Define to 1 if you have the `setgid' function. */
//#define HAVE_SETGID 1

/* Define to 1 if you have the `setgroups' function. */
//#define HAVE_SETGROUPS 1

/* Define to 1 if you have the `setsid' function. */
//#define HAVE_SETSID 1

/* Define to 1 if you have the `setsockopt' function. */
#define HAVE_SETSOCKOPT 1

/* Define to 1 if you have the `setuid' function. */
//#define HAVE_SETUID 1

/* Define to 1 if you have the <signal.h> header file. */
//#define HAVE_SIGNAL_H 1

/* Define to 1 if you have the `socket' function. */
#define HAVE_SOCKET 1

/* struct sock_extended_err needed for extended socket error support */
//#define HAVE_SOCK_EXTENDED_ERR 1

/* Define to 1 if you have the `stat' function. */
//#define HAVE_STAT 1

/* Define to 1 if you have the <stdarg.h> header file. */
#define HAVE_STDARG_H 1

/* Define to 1 if you have the <stdint.h> header file. */
#define HAVE_STDINT_H 1

/* Define to 1 if you have the <stdio.h> header file. */
#define HAVE_STDIO_H 1

/* Define to 1 if you have the <stdlib.h> header file. */
#define HAVE_STDLIB_H 1

/* Define to 1 if you have the `strerror' function. */
#define HAVE_STRERROR 1

/* Define to 1 if you have the <strings.h> header file. */
#define HAVE_STRINGS_H 1

/* Define to 1 if you have the <string.h> header file. */
#define HAVE_STRING_H 1

/* Define to 1 if you have the <stropts.h> header file. */
//#define HAVE_STROPTS_H 1

/* Define to 1 if you have the `syslog' function. */
//#define HAVE_SYSLOG 1

/* Define to 1 if you have the <syslog.h> header file. */
//#define HAVE_SYSLOG_H 1

/* Define to 1 if you have the `system' function. */
#define HAVE_SYSTEM 1

/* Define to 1 if you have the <sys/file.h> header file. */
#define HAVE_SYS_FILE_H 1

/* Define to 1 if you have the <sys/ioctl.h> header file. */
//#define HAVE_SYS_IOCTL_H 1

/* Define to 1 if you have the <sys/mman.h> header file. */
//#define HAVE_SYS_MMAN_H 1

/* Define to 1 if you have the <sys/socket.h> header file. */
//#define HAVE_SYS_SOCKET_H 1

/* Define to 1 if you have the <sys/sockio.h> header file. */
/* #undef HAVE_SYS_SOCKIO_H */

/* Define to 1 if you have the <sys/stat.h> header file. */
#define HAVE_SYS_STAT_H 1

/* Define to 1 if you have the <sys/time.h> header file. */
#define HAVE_SYS_TIME_H 1

/* Define to 1 if you have the <sys/types.h> header file. */
#define HAVE_SYS_TYPES_H 1

/* Define to 1 if you have the <sys/uio.h> header file. */
//#define HAVE_SYS_UIO_H 1

/* Define to 1 if you have <sys/wait.h> that is POSIX.1 compatible. */
//#define HAVE_SYS_WAIT_H 1

/* Define to 1 if you have the `time' function. */
#define HAVE_TIME 1

/* struct tun_pi needed for IPv6 support */
//#define HAVE_TUN_PI 1

/* Define to 1 if you have the <unistd.h> header file. */
#define HAVE_UNISTD_H 1

/* Define to 1 if you have the `vfork' function. */
//#define HAVE_VFORK 1

/* Define to 1 if you have the <vfork.h> header file. */
/* #undef HAVE_VFORK_H */

/* Define to 1 if you have the `vsnprintf' function. */
#define HAVE_VSNPRINTF 1

/* Define to 1 if `fork' works. */
//#define HAVE_WORKING_FORK 1

/* Define to 1 if `vfork' works. */
//#define HAVE_WORKING_VFORK 1

/* Define to 1 if you have the `writev' function. */
//#define HAVE_WRITEV 1

/* Path to ifconfig tool */
//#define IFCONFIG_PATH "/sbin/ifconfig"

/* Name of package */
#define PACKAGE "openvpn"

/* Define to the address where bug reports for this package should be sent. */
#define PACKAGE_BUGREPORT "openvpn-users@lists.sourceforge.net"

/* Define to the full name of this package. */
#define PACKAGE_NAME "OpenVPN"

/* Define to the one symbol short name of this package. */
#define PACKAGE_TARNAME "openvpn"

/* Define to the version of this package. */
#define PACKAGE_VERSION "1.5-beta1" /* replace this with version # */

/* Define to the full name and version of this package. */
#define PACKAGE_STRING "OpenVPN " PACKAGE_VERSION

/* Define to the necessary symbol if this constant uses a non-standard name on
   your system. */
/* #undef PTHREAD_CREATE_JOINABLE */

/* Define as the return type of signal handlers (`int' or `void'). */
#define RETSIGTYPE void

/* The size of a `unsigned int', as computed by sizeof. */
#define SIZEOF_UNSIGNED_INT 4

/* The size of a `unsigned long', as computed by sizeof. */
#define SIZEOF_UNSIGNED_LONG 4

/* Define to 1 if you have the ANSI C header files. */
#define STDC_HEADERS 1

/* Enable strict options check between peers */
/* #undef STRICT_OPTIONS_CHECK */

/* A string representing our target */
#define TARGET_ALIAS "Win32-MinGW"

/* Are we running on Mac OS X? */
/* #undef TARGET_DARWIN */

/* Are we running on FreeBSD? */
/* #undef TARGET_FREEBSD */

/* Are we running on Linux? */
//#define TARGET_LINUX 1

/* Are we running NetBSD? */
/* #undef TARGET_NETBSD */

/* Are we running on OpenBSD? */
/* #undef TARGET_OPENBSD */

/* Are we running on Solaris? */
/* #undef TARGET_SOLARIS */

/* Define to 1 if you can safely include both <sys/time.h> and <time.h>. */
#define TIME_WITH_SYS_TIME 1

/* Use OpenSSL crypto library */
#define USE_CRYPTO 1

/* Use LZO compression library */
#define USE_LZO 1

/* Use pthread-based multithreading */
//#define USE_PTHREAD 1

/* Use OpenSSL SSL library */
#define USE_SSL 1

/* Version number of package */
#define VERSION PACKAGE_VERSION

/* Define to empty if `const' does not conform to ANSI C. */
/* #undef const */

/* Define to `int' if <sys/types.h> doesn't define. */
/* #undef gid_t */

/* Some systems don't define in_addr_t */
/* #undef in_addr_t */

/* Define as `__inline' if that's what the C compiler calls it, or to nothing
   if it is not supported. */
#define inline __inline

/* Define to rpl_malloc if the replacement function should be used. */
/* #undef malloc */

/* Define to `long' if <sys/types.h> does not define. */
/* #undef off_t */

/* Define to `int' if <sys/types.h> does not define. */
/* #undef pid_t */

/* Define to `unsigned' if <sys/types.h> does not define. */
/* #undef size_t */

/* type to use in place of socklen_t if not defined */
#define socklen_t unsigned int

/* Define to `int' if <sys/types.h> doesn't define. */
/* #undef uid_t */

/* 32-bit unsigned type */
#define uint32_t unsigned int

/* 16-bit unsigned type */
#define uint16_t unsigned short

/* 8-bit unsigned type */
#define uint8_t unsigned char

/* Define as `fork' if `vfork' does not work. */
/* #undef vfork */

/* Define to empty if the keyword `volatile' does not work. Warning: valid
   code using `volatile' can become incorrect without. Disable with care. */
/* #undef volatile */
